﻿var options = [];

$(document).ready(function () {
    $("div.drillDown").each(function () {
        var drilldown = $(this);

        //Check if first dropdown is answered
        var answered = $("select:first", drilldown).val();

        // Omit first drilldown since options are always visible
        $("select:gt(0)", drilldown).each(function () {
            var select = $(this);
            var dropDownName = select.attr("name");
            
            _.each($("option[data-parent]", select), function (opt) {
                var parent = $(opt).attr("data-parent");
                options.push({ dropDown: dropDownName, parent: parent, id: $(opt).attr("id"), value: $(opt).val(), text: $(opt).text().trim() });

                if (!answered || (parent && answered != parent))
                    $(opt).detach();
            });

            answered = select.val();
        });
    });

    $("select.dropDownList").on("change", function () {
        var choice = $(this).find(":selected");
        if (isInGrid($(this))) {
            toggleGridOpenEnds(choice);
        } else {
            toggleOpenEnd(choice, true);
        }
    });

    $(".drillDown select").on("change", function () {
        var choiceList = $(this).parent();
        Dropdown_SetChoicesForDrillDown(choiceList);
    });
});

function Dropdown_SetChoicesForDrillDown(choiceList) {
    var choiceLists = choiceList.nextAll(".choiceList");
    toggleOpenEnd($("select option:selected:first", choiceList), true, choiceList);

    if (choiceLists.length > 0) {
        choiceLists.each(function () {
            $(this).find("select option[value!='']").detach();
            $(".openEndHidden", $(this)).hide(); //Hide open ends
            $(".openEnd", $(this)).prop("disabled", true); //Disable open ends
        });

        var next = choiceLists.first();
        var dropDownName = $("select", next).attr("name");

        $("select option:selected", choiceList).each(function (i, selected) {
            _.each(_.filter(options, function (c) { return c.dropDown == dropDownName && (c.parent == $(selected).val() || c.parent == ""); }), function (c) {
                $("select", next).append($('<option>', { value: c.value }).text(c.text).attr("data-parent", c.parent).attr("id", c.id));
            });
        });
    }
} 